# Exercise 01 Solution: Create a Grouped Bar Chart
# Module 5: Data Visualization with ggplot2

library(ggplot2)
library(data.table)
library(here)

vat_gap_analysis <- fread(here("r_training_datax", "data", "Final", "vat_gap_analysis.csv"))

industry_size <- vat_gap_analysis[, .(total_vat = sum(actual_vat)), by = .(industry, firm_size)]

ggplot(industry_size, aes(x = industry, y = total_vat, fill = firm_size)) +
  geom_bar(stat = "identity", position = "dodge") +
  coord_flip() +
  labs(
    title = "VAT Collection by Industry and Firm Size",
    x = NULL,
    y = "Total VAT (USD)",
    fill = "Firm Size"
  ) +
  theme_minimal()
