# Exercise 04 Solution: Create a Layered Scatterplot
# Module 5: Data Visualization with ggplot2

library(ggplot2)
library(data.table)
library(here)

vat_gap_analysis <- fread(here("r_training_datax", "data", "Final", "vat_gap_analysis.csv"))

ggplot(vat_gap_analysis, aes(x = vat_inputs, y = vat_outputs)) +
  geom_point(aes(color = firm_size), alpha = 0.6) +
  geom_smooth(method = "lm", color = "black", se = FALSE) +
  labs(
    title = "Relationship Between VAT Inputs and Outputs",
    subtitle = "By Firm Size",
    x = "VAT Inputs (USD)",
    y = "VAT Outputs (USD)",
    color = "Firm Size"
  ) +
  theme_minimal()
