# Exercise 05 Solution: Create a Faceted Visualization
# Module 5: Data Visualization with ggplot2

library(ggplot2)
library(data.table)
library(here)

vat_gap_analysis <- fread(here("r_training_datax", "data", "Final", "vat_gap_analysis.csv"))

ggplot(vat_gap_analysis, aes(x = vat_gap)) +
  geom_histogram(binwidth = 5000, fill = "#3B9AB2", color = "white") +
  facet_wrap(~ firm_size, scales = "free_y") +
  labs(
    title = "Distribution of VAT Gaps by Firm Size",
    x = "VAT Gap (USD)",
    y = "Number of Firms"
  ) +
  theme_minimal()
